from app.db import database

COLLECTION_NAME = "communication_settings"

def get_communication_settings(db: database.MongoDB) -> dict:
    return db[COLLECTION_NAME].find_one({}) or {}

# def update_communication_settings(data: dict, db: database.MongoDB) -> dict:
#     db[COLLECTION_NAME].update_one({}, {"$set": data}, upsert=True)
#     return get_communication_settings(db)

def update_communication_settings(account_id: str, data: dict, db):
    db[COLLECTION_NAME].update_one({"account_id": account_id}, {"$set": data}, upsert=True)
    return db[COLLECTION_NAME].find_one({"account_id": account_id})
    